<?php

include_once 'conexao.php';
  
class ModeloMateriaTemaMaterialAula
{   
	static public function mdlAddMateriaTemaMaterialAula($dados){
  
		$stmt = Conexao::conectar()->prepare("INSERT INTO materiatemamaterialaula 
						(descricao, idUsuario, dataCadastro,idVaga,idMateriaTema,arquivo) VALUES 
						(:descricao, :idUsuario, :dataCadastro,:idVaga,:idMateriaTema,:arquivo)");
		$stmt->bindParam(":idVaga", $dados["idVaga"], PDO::PARAM_STR);
		$stmt->bindParam(":descricao", $dados["descricao"], PDO::PARAM_STR);
		$stmt->bindParam(":dataCadastro", $dados["dataCadastro"], PDO::PARAM_STR);
		$stmt->bindParam(":idMateriaTema", $dados["idMateriaTema"], PDO::PARAM_STR);
		$stmt->bindParam(":idUsuario", $dados["idUsuario"], PDO::PARAM_STR);
		$stmt->bindParam(":arquivo", $dados["arquivo"], PDO::PARAM_STR);
 
		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}

	} 

	static public function mdlMostrarTodasAsPerguntasDaVagaPoridVaga($idVaga) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM pergunta where idVaga = :idVaga and idExercicioTema = '' order by idPergunta");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;
 
	}  
 
	static public function mdlMostrarTodosOsArquivosDaMateriaPorIdVagaEIdTema($idVaga, $idMateriaTema) { 

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM materiatemamaterialaula where idVaga = :idVaga and idMateriaTema = :idMateriaTema");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt->bindParam(":idMateriaTema", $idMateriaTema, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;
 
	}  

	static public function mdlMostrarEOrdenarPerguntasPorNumeroDeidMateriaTemaTodasAsPerguntasDaVagaPoridVaga($idVaga) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM pergunta where idVaga = :idVaga order by idPergunta");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;
 
	}

	static public function mdlMostrarEOrdenarPerguntasTodasPerguntasDaAvaliacaoPorIdVagaEIdTema($idVaga,$idTema) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM pergunta where idVaga = :idVaga and idExercicioTema = '$idTema' order by idPergunta");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt->bindParam(":idTema", $idTema, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;
 
	}

	static public function mdlVerificarPerguntaPoridVagaEPregunta($idVaga,$pergunta) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM pergunta where idVaga = :idVaga and pergunta = :pergunta order by idPergunta");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt->bindParam(":pergunta", $pergunta, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;
 
	} 
 
	static public function mdlMostrarPerguntaPorIdPergunta($idPergunta) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM pergunta where idPergunta = :idPergunta");
			$stmt->bindParam(":idPergunta", $idPergunta, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarPerguntaPoridVagaENumeroDeidMateriaTema($idVaga,$idMateriaTema) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM pergunta where idVaga = :idVaga and idMateriaTema = :idMateriaTema");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt->bindParam(":idMateriaTema", $idMateriaTema, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarPerguntaDaAvaliacaoPoridVagaENumeroDeidMateriaTemaEIdTema($idVaga,$idMateriaTema,$idTema) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM pergunta where idVaga = :idVaga and idMateriaTema = :idMateriaTema and idExercicioTema = :idTema");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt->bindParam(":idMateriaTema", $idMateriaTema, PDO::PARAM_STR);
			$stmt->bindParam(":idTema", $idTema, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}
 
	

	static public function mdlEditarPergintaPorIdPergunta($idPergunta, $idMateriaTema,$pergunta){
 
		$stmt = Conexao::conectar()->prepare("UPDATE pergunta SET idMateriaTema = :idMateriaTema, pergunta = :pergunta where idPergunta = :idPergunta ");
		$stmt->bindParam(":idPergunta", $idPergunta, PDO::PARAM_STR);
		$stmt->bindParam(":idMateriaTema", $idMateriaTema, PDO::PARAM_STR);
		$stmt->bindParam(":pergunta", $pergunta, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}
 
	static public function mdlEliminarMateriaTemaMaterialAula($id){
 
		$stmt = Conexao::conectar()->prepare("DELETE FROM materiatemamaterialaula where idMateriaTemaMaterialAula = :id ");
		$stmt->bindParam(":id", $id, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

}



?>